function UpdateSingleSpec(handles,No)

%% Get Handles
Axes       = get(handles.Load,'UserData');
Energies   = get(handles.ZLPAlign,'UserData');
Data       = get(handles.SingleSpec,'UserData');
NormImg    = get(handles.NormImg,'Value');

SingleSpec = Data{1};
pos        = Data{2};
OldEne     = Data{4};
specdiff   = Data{5};
image      = get(handles.CAxisMin,'UserData');
image      = image{1};

YScale     = size(image,1)*(Axes(2)/2);
XScale     = size(image,2)*(Axes(1)/2);

pos(1) = floor( (  pos(1)+XScale)/Axes(1)+1);
pos(2) = floor( ( -pos(2)+YScale)/Axes(2)+1);

y = pos(2);
if y<1
    y=1;
elseif y>size(image,1)
    y=size(image,1);
end

x = pos(1);
if x<1
    x=1;
elseif x>size(image,2)
    x=size(image,2);
end

Pos=[y,x];


Spec     = reshape(image(Pos(1),Pos(2),:),[1,size(image,3)]);
OldEne{No}= Spec;
Color=['k','m','c','y','r','b','g'];
figure(SingleSpec);
gca;


for i=1:length(OldEne)
    Spec     =OldEne{i}(1,:);
    if NormImg==0
        plot(Energies,Spec,Color(i),'LineWidth',1.5);
        ylim([0, max(Spec)]);
        ylabel( 'Intensity [Counts]' );
    else
        plot(Energies,Spec,Color(i),'LineWidth',1.5);
        ylim([0, max(Spec)]);
        ylabel( 'Loss propability [a.u.]' );
    end
    xlabel( 'Electron energy-loss [eV]' );
    title('EEL-Spectrum');
    set(gca,'FontSize',18);
    hold on
end
hold off


if length(OldEne)>1
    try
    figure(specdiff);
    gca;
    
    for i=2:length(OldEne)
        SpecDiff     =OldEne{i}(1,:)-OldEne{1}(1,:);
        if NormImg==0
            plot(Energies,SpecDiff,Color(i),'LineWidth',1.5);
            MaxDiff = max(SpecDiff);
            if MaxDiff>0
                ylim([0,MaxDiff ]);
            end
            ylabel( 'Intensity [Counts]' );
        else
            MaxDiff= max(SpecDiff);
            plot(Energies,SpecDiff,Color(i),'LineWidth',1.5);
            if MaxDiff>0
                ylim([0, MaxDiff]);
            end
            ylabel( 'Loss propability [a.u.]' );
        end
        xlabel( 'Electron energy-loss [eV]' );
        set(gca,'FontSize',18);
        hold on
        title('Differences');
    end
    hold off
    catch
        specdiff=[];
    end
end

Data = {SingleSpec,pos,No,OldEne,specdiff};
set(handles.SingleSpec,'UserData',Data);
clearvars all
end
